USE Obfuscation;

IF OBJECT_ID( 'teObfuscationColumn' ) IS NOT NULL
BEGIN
    RAISERROR( 'This script has already been run', 0, 1 );
    RETURN;
END

CREATE TABLE teObfuscationColumn(
    ColumnID INT NOT NULL CONSTRAINT pkObfuscationColumn PRIMARY KEY CLUSTERED,
    TableID INT NOT NULL,
    ColumnName VARCHAR(100) NOT NULL,
    ColumnTypeCD TINYINT NOT NULL,

    CONSTRAINT fkObfuscationColumn_ObfuscationTable 
    FOREIGN KEY( TableID ) 
    REFERENCES teObfuscationTable( TableID ),

    CONSTRAINT fkObfuscation_ColumnType
    FOREIGN KEY( ColumnTypeCD )
    REFERENCES tdColumnType( ColumnTypeCD )
);

CREATE NONCLUSTERED INDEX Obfuscation_TableID_ColumnName
ON teObfuscationColumn(
    TableID,
    ColumnName 
) INCLUDE(
    ColumnTypeCD
) ;